## Implicit Conversions

MDX automatically converts several types (aka. implicit conversions).




### Description

MDX converts implicitly (automatically) some types if required by the context.

As an example, if a function is expecting a member as first parameter and receives a hierarchy MDX is going to implicitly convert the hierarchy into a member using the hierarchy's default member.

For readability, it is not advised to use implicit conversions as the actual value used is hidden to somebody not aware of the conversion happening in the background.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Implicit conversion from member to set

</div>

<div class="ic3-mdx-example-body" style="display:none">

If required a member is automatically converted to a set. The resulting set contains the member as single item.

**Query**

```
[Geography].[Geo].[Switzerland]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Switzerland]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
{[Geography].[Geo].[Switzerland]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Implicit conversion from tuple to set

</div>

<div class="ic3-mdx-example-body" style="display:none">

If required a tuple is automatically converted to a set. The resulting set contains the tuple as single item.

**Query**

```
([Geography].[Geo].[Switzerland])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Switzerland]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
{([Geography].[Geo].[Switzerland])}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Implicit conversion from level to set

</div>

<div class="ic3-mdx-example-body" style="display:none">

If required a level is automatically converted to a set. The resulting set contains all level's members.

**Query**

```
[Geography].[Geo].[Country]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[Country].[Mexico], 
  [Geography].[Geo].[Country].[United States], 
  [Geography].[Geo].[Country].[Venezuela], 
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[Country].[Switzerland]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
[Geography].[Geo].[Country].members
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Implicit conversion from hierarchy to set

</div>

<div class="ic3-mdx-example-body" style="display:none">

If required a hierarchy is automatically converted to a set. The resulting set contains
the default member of the hierarchy as single item.

**Query**

```
[Geography].[Geo]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[All Regions]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
[Geography].[Geo].defaultMember
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Implicit conversion from a hierarchy to a member

</div>

<div class="ic3-mdx-example-body" style="display:none">

If required an hierarchy is converted to a member; its default member is returned.

**Query**

```
[Geography].[Geo].children
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
[Geography].[Geo].defaultMember.children
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Implicit conversion from null entity to set

</div>

<div class="ic3-mdx-example-body" style="display:none">

If required a null entity is automatically converted to a set. The resulting is an empty set.

**Query**

```
Tail(null)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Implicit conversion from dimension with multiple hierarchies to set

</div>

<div class="ic3-mdx-example-body" style="display:none">

Dimension with multiple hierarchies cannot be converted to a set.

**Query**

```
[Geography]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_DIMENSION_WITH_MORE_THAN_ONE_HIERARCHY](icCubeError.md#olap_function_dimension_with_more_than_one_hierarchy)</td></tr><tr><td>Error Message</td><td>

the '[Geography]' dimension contains more than one hierarchy, therefore the hierarchy must be explicitly specified.</td></tr></table>


 
</div>

                                                                                                            

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
